class LoginController < ApplicationController

  before_filter :authorize, :except => :login

  def login
    session[:user_id] = nil
    if request.post?
      user = User.authenticate(params[:short_name], params[:password])
      if user
        session[:user_id] = user.id
        uri = session[:original_uri]
        session[:original_uri] = nil
        redirect_to(uri || {:controller => "user_admin", :action => "index"} )
      else
        flash[:notice] = "Invalid user/password combination"
      end
    end
  end

  def logout
    session[:user_id] = nil
    flash[:notice] = "You are logged out"
    redirect_to( :action => "login" )
  end

end